$TITLE CGE3b
$OFFUPPER

*INTRODUCTION====================================================
$ONTEXT

In this file, the starting point is CGE3a.
The new features are
(1) the assumption that, for labor, wages are "distorted"
    (wages are no longer uniform for both activities); and
(2) labor can be unemployed with an infinitely elastic supply
    of labor at a wage which is fixed in real and nominal terms.

The line before any new feature or modification starts with
"*++1" or "++2" depending on which of the above is implemented
Sets and parameters for simulations and reports have been
overhauled completely.
Search for " *Complete!! " for some errors and omissions
Move " $ONTEXT " after completing the first " *Complete!! "
and press [SHIFT] [F9] to check the coding up to that point

$OFFTEXT

*SETS============================================================

SETS

 AC global set (SAM accounts and other items)
   /AGR-A   agricultural activity
    NAGR-A  non-agricultural activity
    AGR-C   agricultural commodity
    NAGR-C  non-agricultural commodity
    LAB     labor
    CAP     capital
    U-HHD   urban household
    R-HHD   rural household
    S-I     savings-investment
    TOTAL   total account in SAM   /

 ACNT(AC) all elements in AC except total

 A(AC)  activities
        /AGR-A, NAGR-A/

 C(AC)  commodities
        /AGR-C, NAGR-C/

 F(AC)  factors
        /LAB, CAP/

 H(AC)  households
        /U-HHD, R-HHD/
   ;

 ALIAS(AC,ACP); ALIAS(C,CP); ALIAS(F,FP);
 ACNT(AC) = YES; ACNT('TOTAL') = NO; ALIAS(ACNT,ACNTP);


*PARAMETERS======================================================

PARAMETERS

 ad(A)       efficiency parameter in the production fn for a ??
 alpha(F,A)  share of value-added to factor f in activity a
 beta(C,H)   share of household consumption spending on commodity c
 cpi         consumer price index
 cwts(C)     weight of commodity c in the CPI
 ica(C,A)    qnty of c as intermediate input per unit of activity a
 qinvbar(C)  base-year qnty of investment demand for commodity c
 shry(H,F)   share for household h in the income of factor f
 theta(A,C)  yield of output c per unit of activity a
 ;

*VARIABLES=======================================================

VARIABLES
 IADJ      investment adjustment factor
 MPS(H)    marginal (and average) propensity to save for household h
 P(C)      demander price for commodity c
 PA(A)     price of activity a
 PVA(A)    value-added (or net) price for activity a
 Q(C)      output level for commodity c
 QA(A)     level of activity a
 QF(F,A)   quantity demanded of factor f from activity a
*++2
 QFS(F)    supply of factor f
 QH(C,H)   quantity consumed of commodity c by household h
 QINT(C,A) qnty of commodity c as intermediate input to activity a
 QINV(C)   quantity of investment demand for commodity c
 WALRAS    dummy variable (zero at equilibrium)
 WF(F)     average price of factor f
*++1
 WFDIST(F,A) wage distortion factor for factor f in activity a

 YF(H,F)   income of household h from factor f
 YH(H)     income of household h
 ;

*EQUATIONS=======================================================

EQUATIONS

*PRICE, PRODUCTION AND COMMODITY BLOCK++++++++
 PRODFN(A)      Cobb-Douglas production function for activity a
 FACDEM(F,A)    demand for factor f from activity a
 INTDEM(C,A)    intermediate demand for commodity c from activity a
 OUTPUTFN(C)    output of commodity c
 PADEF(A)       price for activity a
 PVADEF(A)      value-added price for activity a

*INSTITUTION BLOCK+++++++++++++++++++++
 FACTTRNS(H,F)  transfer of income from factor f to h-hold h
 HHDINC(H)      income of household h
 HHDEM(C,H)     consumption demand for household h & commodity c
 INVDEM(C)      investment demand for commodity c

*SYSTEM CONSTRAINT BLOCK+++++++++++++++
 FACTEQ(F)      market equilibrium condition for factor f
 COMEQ(C)       market equilibrium condition for commodity c
 SAVINV         savings-investment balance
 PNORM          price normalization
 ;

*PRICE, PRODUCTION AND COMMODITY BLOCK++++++++

 PRODFN(A)..    QA(A) =E= ad(A)*PROD(F, QF(F,A)**alpha(F,A));
*++1
*Complete!!
*A sector's demand for a factor depends upon the real fctor price. Now that
*we allow the price for a factor to vary across sectors, we need to modify the
*factor demand equation below. [Note that the equation is in a slightly different
*form from CGE3a, with QF, rather than WF, on the left. This makes no
*difference but is a little easier to understand as a factor demand equation.]
 FACDEM(F,A)..  QF(F,A) =E= alpha(F,A)*QA(A) /(WF(F)/PVA(A)) ;

 INTDEM(C,A)..  QINT(C,A) =E= ica(C,A)*QA(A);

 OUTPUTFN(C)..  Q(C) =E= SUM(A, theta(A,C)*QA(A));

 PADEF(A)..     PA(A) =E= SUM(C, theta(A,C)*P(C));

 PVADEF(A)..    PVA(A) =E= PA(A) - SUM(C, P(C)*ica(C,A));

*INSTITUTION BLOCK+++++++++++++++++++++
*++1
*Complete!!
*You should be able to figure out what is needed here.
 FACTTRNS(H,F)..  YF(H,F)
                  =E= shry(H,F)*SUM(A, WF(F)*QF(F,A))

 HHDINC(H)..      YH(H) =E= SUM(F, YF(H,F));

 HHDEM(C,H)..     QH(C,H) =E=
                  beta(C,H)*(1 - MPS(H))*YH(H)/P(C);

 INVDEM(C)..      QINV(C) =E= qinvbar(C)*IADJ;

*SYSTEM CONSTRAINT BLOCK+++++++++++++++
*++2
*Complete!!
*You do not need to add or remove anything in this equation, but there is one
*minor change you should make for consistency. What is it?
 FACTEQ(F)..      SUM(A, QF(F,A)) =E= qfs(F);

 COMEQ(C)..       Q(C) =E= SUM(H, QH(C,H)) + SUM(A, QINT(C,A))
                  + QINV(C);

 SAVINV..         SUM(C, P(C)*QINV(C)) + WALRAS =E=
                  SUM(H, MPS(H)*YH(H)) ;

 PNORM..          SUM(C, cwts(C)*P(C)) =E= cpi;

*MODEL===========================================================

MODELS

 CGE3b  Model with gov't and flexible factor market treatment
 /ALL/
 ;

*SOCIAL ACCOUNTING MATRIX========================================
*ONTEXT
TABLE SAM(AC,ACP)  social accounting matrix

         AGR-A  NAGR-A  AGR-C  NAGR-C  LAB  CAP  U-HHD  R-HHD  S-I
AGR-A                     250
NAGR-A                            305
AGR-C       60      40                              50     75   25
NAGR-C      40      60                             100     50   55
LAB         72      80
CAP         78     125
U-HHD                                   80  120
R-HHD                                   72   83
S-I                                                 50     30

 ;

*$OFFTEXT

*The following provides a way of reading the SAM from an excel sheet. If you
*switch it on, you need to turn off the Table statement above
* PARAMETER SAM(AC,ACP) ;
*$LIBINCLUDE XLIMPORT SAM DATA.XLS SAMCGE3b


PARAMETER
 tdiff(AC) column minus row total for account AC;
          SAM('TOTAL',ACNTP) = SUM(ACNT, SAM(ACNT,ACNTP));
          SAM(ACNT,'TOTAL') = SUM(ACNTP, SAM(ACNT,ACNTP));
          tdiff(ACNT)       = SAM('TOTAL',ACNT) - SAM(ACNT,'TOTAL');

DISPLAY SAM, tdiff;


*ASSIGNMENTS FOR PARAMETERS AND VARIABLES========================

PARAMETERS
*The following parameters are used to define initial values of
*model variables.
*++1
*++2
 IADJ0, MPS0(H), P0(C), PA0(A), PVA0(A), PX0(C), Q0(C), QA0(A),
 QF0(F,A), QFS0(F), QH0(C,H), QINT0(C,A), QINV0(C), WF0(F),
 WFDIST0(F,A), YF0(H,F), YG0, YH0(H)
 ;

*++1
*++2
*FACTOR EMPLOYMENT AND PRICES++++++++++
*This section is completely new. It includes all items related to factor
*prices and quantities.

PARAMETERS
*Complete!!
 labor(A)     quantity of labor employed by activity (no. of workers)
              /                  /
 wfa(F,A)     wage for factor f in activity a (only for calibration)
 costgap(F,A) gap calibrated factor cost - SAM value (should be zero)
 ;

*Defining factor employment and supply
*Complete!!
 QF0('LAB',A) =             ;
 QF0('CAP',A) = SAM('CAP',A);
*Complete!!
 QFS0(F)      =             ;

*Computing activity-specific wage
*Complete!!
 wfa(F,A)     =             ;

*Computing average wage
*Complete!!
 WF0(F)       =                               ;

*Computing wage distortion factors
*Complete!!
 WFDIST0(F,A) =                         ;

*Checking calibration
*Complete!!
 costgap(F,A) =                - SAM(F,A);

DISPLAY wfa, costgap;
*++1
*++2 End of new section on labor

*PRICE, PRODUCTION AND COMMODITY BLOCK++++++++

 PA0(A)     = 1;
 PVA0(A)    = SUM(F, SAM(F,A)) / (SAM(A,'TOTAL')/PA0(A));
 P0(C)      = 1;

 Q0(C)      = SAM('TOTAL',C)/P0(C);
 QA0(A)     = SAM('TOTAL',A)/PA0(A);
 QINT0(C,A) = SAM(C,A)/P0(C);

 alpha(F,A) = SAM(F,A) / SUM(FP, SAM(FP,A));
 ad(A)      = QA0(A) / PROD(F, QF0(F,A)**alpha(F,A));
 ica(C,A)   = (SAM(C,A)/P0(C)) / QA0(A);
 theta(A,C) = (SAM(A,C)/P0(C)) / QA0(A);

*INSTITUTION BLOCK+++++++++++++++++++++

 IADJ0       = 1;

 MPS0(H)     = SAM('S-I',H) / (SAM('TOTAL',H));
 QH0(C,H)    = SAM(C,H)/P0(C);
 QINV0(C)    = SAM(C,'S-I')/P0(C);
 YF0(H,F)    = SAM(H,F);
 YH0(H)      = SAM('TOTAL',H);
 beta(C,H)   = SAM(C,H)/SUM(CP, SAM(CP,H));
 qinvbar(C)  = SAM(C,'S-I')/P0(C);
 shry(H,F)   = SAM(H,F)/SAM('TOTAL',F);

*SYSTEM CONSTRAINT BLOCK+++++++++++++++

 cwts(C)     = SUM(H, SAM(C,H)) / SUM((CP,H), SAM(CP,H));
 cpi         = SUM(C, cwts(C)*P0(C));

*INITIALISATION OF VARIABLES+++++++++++

 IADJ.L      = IADJ0;
 MPS.L(H)    = MPS0(H);
 P.L(C)      = P0(C);
 PA.L(A)     = PA0(A);
 PVA.L(A)    = PVA0(A);
 Q.L(C)      = Q0(C);
 QA.L(A)     = QA0(A);
 QF.L(F,A)   = QF0(F,A);
*++2
 QFS.L(F)    = QFS0(F);
 QH.L(C,H)   = QH0(C,H);
 QINT.L(C,A) = QINT0(C,A);
 QINV.L(C)   = QINV0(C);
 WF.L(F)     = WF0(F);
*++1
 WFDIST.L(F,A) = WFDIST0(F,A);
 YF.L(H,F)   = YF0(H,F);
 YH.L(H)     = YH0(H);

*DISPLAY+++++++++++++++++++++++++++++++

DISPLAY
 ad, alpha, beta, cpi, cwts, ica, shry, qinvbar, theta,
*++1
*++2
 IADJ.L, MPS.L, P.L, PA.L, PVA.L, Q.L, QA.L, QF.L, QFS.L,
 QH.L, QINT.L, QINV.L, WF.L, WFDIST.L, YF.L
 ;


*SETS AND PARAMETERS FOR SIMULATIONS AND REPORTS++++++++

*++
SETS
 SIM  simulations
     /BASE   base simulation
      CINCIDSFE increase in capital stock with investment driven savings and FE
      CINCSDIUE increase in capital stock with savings driven investment and UE
      /
      ;
*++
*SELECTING CLOSURES++++++++++++++++++++

*SAVINGS-INVESTMENT BALANCE

PARAMETER
 SICLOS(SIM) savings-investment closure
*Select 1 or 2
*if SICLOS = 1, savings is investment-driven
*if SICLOS = 2, investment is savings-driven

 CAPCLOS(SIM)   closure for capital market
*Select 1 or 2
*if CAPCLOS = 1, capital is mobile and fully employed
*if CAPCLOS = 2, capital is activity-specific and fully employed

 LABCLOS(SIM)   closure for labor market
*Select 1 or 2
*if LABCLOS = 1, labor is mobile and fully employed
*if LABCLOS = 2, labor is mobile and unemployed (fixed wages)
   ;

*DEFAULT VALUES FOR CLOSURES
 SICLOS (SIM)  = 1 ;
 CAPCLOS(SIM)  = 1 ;
 LABCLOS(SIM)  = 1 ;
*OVERWRITE THESE VALUES FOR SPECIFIC SIMULATIONS BELOW
*eg  SICLOS('CAPINCR') = 2
 SICLOS ('CINCIDSFE') = 1;
 SICLOS ('CINCSDIUE') = 2;
 LABCLOS('CINCIDSFE') = 1;
 LABCLOS('CINCSDIUE') = 2;


DISPLAY SICLOS, CAPCLOS, LABCLOS ;

PARAMETERS
 QFSCAPSIM(SIM)   supply of capital for simulation sim
 IADJREP(SIM)     investment adjustment factor
 MPSREP(H,SIM)    marginal (and avg) propensity to save for household h
 PREP(C,SIM)      demander price for commodity c
 PAREP(A,SIM)     price of activity a
 PVAREP(A,SIM)    value-added price for activity a
 PXREP(C,SIM)     producer price (excl. sales tax) for commodity c
 QREP(C,SIM)      output level for commodity c
 QAREP(A,SIM)     level of activity a
 QFREP(F,A,SIM)   demand for factor f from activity a
 QFSREP(F,SIM)    supply of factor f for sim
 QHREP(C,H,SIM)   consumption of commodity c by household h
 QINTREP(C,A,SIM) qnty of commodity c as intermed. input for activity a
 QINVREP(C,SIM)   quantity of investment by commodity of origin c
 WFREP(F,SIM)     average price of factor f
 WFAREP(F,A,SIM)  price of factor f for activity a
 WFDISTREP(F,A,SIM) wage distortion factof for factor f in activity a
 YFREP(H,F,SIM)   income of household h from factor f
 YHREP(H,SIM)     income of household h
 WALRASREP(SIM)   dummy variable (zero at equilibrium)
 ;

 QFSCAPSIM('BASE')  = QFS.L('CAP');

 QFSCAPSIM('CINCIDSFE')  = 1.1*QFS.L('CAP');
 QFSCAPSIM('CINCSDIUE')  = 1.1*QFS.L('CAP');

DISPLAY QFSCAPSIM;

LOOP(SIM,

 QFS0('CAP') = QFSCAPSIM(SIM);

IF(SICLOS(SIM) EQ 1,
*Investment-driven savings -- MPS('U-HHD') is flexible, permitting
*the savings value to adjust.
 IADJ.FX         = IADJ0;
 MPS.FX('R-HHD') = MPS0('R-HHD');
 MPS.LO('U-HHD') = -INF; MPS.UP('U-HHD') = +INF;
 MPS.L('U-HHD')  = MPS0('U-HHD');
 );

IF(SICLOS(SIM) EQ 2,
*Savings-driven investment -- IADJ is flexible, permitting
*investment quantities and the investment value to adjust.
 MPS.FX(H) = MPS0(H);
 IADJ.LO   = -INF; IADJ.UP = +INF; IADJ.L = IADJ0;
 );
IF(CAPCLOS(SIM) EQ 1,
*Capital is fully employed and mobile. WF('CAP') is the market-clearing
*variable for the unified capital market.

 WFDIST.FX('CAP',A) = WFDIST0('CAP',A);

 WF.LO('CAP')       = -INF; WF.UP('CAP') = +INF;
 WF.L('CAP')        = WF0('CAP');

 QF.LO('CAP',A)     = -INF; QF.UP('CAP',A) = +INF;
 QF.L('CAP',A)      = QF0('CAP',A);

 QFS.FX('CAP')      = QFS0('CAP');
 );

IF(CAPCLOS(SIM) EQ 2,
*Capital is fully employed and activity-specific.
*WFDIST('CAP',A) is the market-clearing variable, one for
*each segment of the capital market.

 WFDIST.LO('CAP',A) = -INF; WFDIST.UP('CAP',A) = +INF;
 WFDIST.L('CAP',A)  = WFDIST0('CAP',A);

 WF.FX('CAP')       = WF0('CAP');

 QF.FX('CAP',A)     = QF0('CAP',A);

 QFS.LO('CAP') = -INF; QFS.UP('CAP') = +INF;
 QFS.L('CAP') = QFS0('CAP');
 );

IF(LABCLOS(SIM) EQ 1,
*Labor is fully employed and mobile. WF('LAB') is the market-clearing
*variable for the unified labour market.

 WFDIST.FX('LAB',A) = WFDIST0('LAB',A);

 WF.LO('LAB') = -INF; WF.UP('LAB') = +INF;
 WF.L('LAB')  = WF0('LAB');

 QF.LO('LAB',A) = -INF; QF.UP('LAB',A) = +INF;
 QF.L('LAB',A) = QF0('LAB',A);

 QFS.FX('LAB')      = QFS0('LAB');
 );

IF(LABCLOS(SIM) EQ 2,
*Labor is unemployed and mobile. For each activity, the wage,
*WFDIST('LAB',A)*WF('LAB'), is fixed. QFS('LAB') is the market-clearing
*variable for the unified labor market.

 WFDIST.FX('LAB',A) = WFDIST0('LAB',A);

 WF.FX('LAB')   = WF0('LAB');

 QF.LO('LAB',A) = -INF; QF.UP('LAB',A) = +INF;
 QF.L('LAB',A)  = QF0('LAB',A);

 QFS.LO('LAB')= -INF; QFS.UP('LAB') = +INF;
 QFS.L('LAB') = QFS0('LAB');
 );


 CGE3b.HOLDFIXED = 1;

 SOLVE CGE3b USING MCP;

 IADJREP(SIM)       = IADJ.L;
 MPSREP(H,SIM)      = MPS.L(H);
 PREP(C,SIM)        = P.L(C);
 PAREP(A,SIM)       = PA.L(A);
 PVAREP(A,SIM)      = PVA.L(A);
 QREP(C,SIM)        = Q.L(C);
 QAREP(A,SIM)       = QA.L(A);
 QFREP(F,A,SIM)     = QF.L(F,A);
 QFSREP(F,SIM)      = QFS.L(F);
 QHREP(C,H,SIM)     = QH.L(C,H);
 QINTREP(C,A,SIM)   = QINT.L(C,A);
 QINVREP(C,SIM)     = QINV.L(C);
 WFREP(F,SIM)       = WF.L(F);
 WFAREP(F,A,SIM)    = WF.L(F)*WFDIST.L(F,A);
 WFDISTREP(F,A,SIM) = WFDIST.L(F,A);
 YFREP(H,F,SIM)     = YF.L(H,F);
 YHREP(H,SIM)       = YH.L(H);
 WALRASREP(SIM)     = WALRAS.L;
 );

 OPTION QFREP:3:1:1, QHREP:3:1:1, QINTREP:3:1:1, WFAREP:3:1:1,
        WFAREP:3:1:1, WFDISTREP:3:1:1, YFREP:3:1:1
       ;

DISPLAY
 IADJREP, MPSREP, PREP, PAREP, PVAREP, QREP,
 QAREP, QFREP, QFSREP, QHREP, QINTREP, QINVREP, WFREP, WFAREP,
 WFDISTREP, YFREP, YHREP, WALRASREP
 ;